import socket
import struct
import sys
import binascii
import base64
import datetime
import time

arguments = sys.argv

MCAST_GRP = arguments[1]
MCAST_PORT = (arguments[1], int(arguments[2]))

#MCAST_GRP = '239.100.100.18'
#MCAST_PORT = ('239.100.100.18', 12121)

sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
sock.bind(MCAST_PORT) 

group = socket.inet_aton(MCAST_GRP)
mreq = struct.pack('4sl', group, socket.INADDR_ANY)

sock.setsockopt(socket.IPPROTO_IP, socket.IP_ADD_MEMBERSHIP, mreq)

print >>sys.stderr, 'Comienza a escuchar los mensajes de %s:%s' % MCAST_PORT

while True:
  values, address = sock.recvfrom(17)
  print >>sys.stderr, 'Received %s bytes from %s at %s' % ( len(values), address, time.strftime( "%d-%m-%Y %H:%M:%S" ) )

  totalMensajes = binascii.b2a_hex( values[2:3] )
  grupoMarketData = ord( values[3] )
  sesion = ord( values[4] )
  numeroSecuencia = binascii.b2a_hex( values[5:9] )
  fechaHora = float(int(binascii.b2a_hex( values[9:17] ), 16)) / 1000.0
  fechaHoraFormatter = datetime.datetime.fromtimestamp( fechaHora ).strftime('%d-%m-%Y %H:%M:%S')

  print >>sys.stderr, 'totalMensajes=%s, GrupoMarketData=%s, sesion=%s, secuencia:%s, fechaHora=%s %s ' % ( int(totalMensajes, 16), grupoMarketData, sesion, int(numeroSecuencia, 16), fechaHora, fechaHoraFormatter )
  print binascii.b2a_hex(values)
  print "==========================="
